<?php
/**
 * @license MIT
 *
 * Modified by learndash on 13-January-2025 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */

namespace StellarWP\Learndash\Illuminate\Contracts\Encryption;

interface StringEncrypter
{
    /**
     * Encrypt a string without serialization.
     *
     * @param  string  $value
     * @return string
     *
     * @throws \StellarWP\Learndash\Illuminate\Contracts\Encryption\EncryptException
     */
    public function encryptString($value);

    /**
     * Decrypt the given string without unserialization.
     *
     * @param  string  $payload
     * @return string
     *
     * @throws \StellarWP\Learndash\Illuminate\Contracts\Encryption\DecryptException
     */
    public function decryptString($payload);
}
