# JetBlocks For Elementor

Enjoy the easy-to-use widgets made for enriching headers & footers with content.

# ChangeLog

## 1.3.21
* Fixed: Login Form “Stay on the current page” built a wrong URL on subdirectory.
* Updated: Site Logo widget sizing — more consistent width/height handling and responsive behavior.
* Updated: Reset Password Form text token — %x → %s to output the minimum length correctly.
* Fixed: Sticky option conflict with Elementor caching — stabilized sticky behavior under cached assets.
* Fixed: Auth Links logout redirect from CPT archive pages — now returns to the current archive URL instead of the first single post.

## 1.3.20.1
* Fixed: PHPCS/WP Security Standards — minor issues.

## 1.3.20
* Fixed: PHPCS/WP Security Standards — escaped dynamic output, sanitized request data, and added nonce verification across widgets/templates.

## 1.3.19.1
* Fixed: Cross-Site Scripting (XSS) vulnerability in the plugin interface, which could potentially allow an attacker to inject malicious scripts.
* Fixed: Site Logo widget now properly supports SVG logos by rendering inline SVG code when a custom logo is set as an SVG, ensuring correct display and accessibility.

## 1.3.19
* Fixed: Navigation Menu — the dropdown menu no longer closes unexpectedly when clicking on the arrow of a menu item.
* Added: Site Logo widget — added the ability to pull the logo from the global WordPress Site Logo settings ("From Site Logo" option), ensuring compatibility with both classic and block themes.
* Fixed: WooCommerce Shopping Cart — cart now properly redirects to the cart page when "Show Cart Dropdown" is disabled, regardless of the trigger type.
* Fixed: Search Widget Accessibility — improved accessibility by addressing empty button and label issues as reported by WAVE extension.
* Added: Dynamic Tags support for the Label field in the Hamburger Panel widget, allowing the use of shortcodes and dynamic content.
* Updated: jet-elementor-extension module to the latest secure version.

## 1.3.18
* Added: Overlay option for WooCommerce Cart widget - https://github.com/Crocoblock/suggestions/issues/4317;
* Added: Option to hide the WooCommerce Cart widget when the cart is empty - https://github.com/Crocoblock/suggestions/issues/3761;
* Fixed: Minor style inconsistencies on different pages in the WooCommerce Cart widget - https://github.com/Crocoblock/suggestions/issues/4192;

## 1.3.17
* Fixed: Sticky Section compatibility with columns and containers;
* Added: `Stop Sticky at Parent End` control in the Jet Sticky section.

## 1.3.16.1
* Fixed: Prevent unauthorized access to templates in REST API;
* Fixed: Prevent php warning.

## 1.3.16
* Added: 'Close Cart Dropdown on Click Outside' option and Escape key handling for WooCommerce Shopping Cart widget - https://github.com/Crocoblock/suggestions/issues/7817;
* Added: 'Open Cart Dropdown on Product Add' option for WooCommerce Shopping Cart widget - https://github.com/Crocoblock/suggestions/issues/7858;
* Fixed: Shopping Cart behavior for hover trigger type on mobile devices; 
* Fixed: Prevent immediate redirect on first tap for Navigation Menu items with submenus on tablet in landscape mode.

## 1.3.15
* Added: 'Reset Page URL' option for Reset Password Form Widget.

## 1.3.14
* Added: Blog Link to breadcrumbs for default archives and single posts;
* Fixed: dropdown icon in the Navigation Menu Widget.

## 1.3.13
* Added: Woo Lost password endpoint compatibility in the Reset Password Form Widget;
* Added: eye icon to the Login Form widget;
* Updated: JetDashboard module to v2.2.0;
* Fixed: accessibility in the Hamburger Panel Widget.

## 1.3.12.1
* Fixed: Escape potentialy unsafe data before print.

## [1.3.12](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.12) - 29.04.2024
* Added: ability to set length password in the Reset Password Form Widget
* Added: new icons of widgets
* Fixed: shopping cart content for editor in the Woo Cart Widget
* Fixed: shopping cart redirects the user on the cart page in the Woo Cart Widget
* Fixed: redirect after form submission in the Registration Form Widget
* Fixed: shopping cart scroll for safari in the Woo Cart Widget
* Fixed: breadcrumbs module
* Fixed: minor issues

## [1.3.11](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.11) - 20.03.2024
* Added: [Crocoblock/suggestions#6976](https://github.com/Crocoblock/suggestions/issues/6976)
* Added: WPML Compatibility
* Added: Profile builder compatibility in the Reset Password Form widget
* Fixed: shopping cart scroll for mobile device in the Woo Cart widget
* Fixed: minor issues
* Updated: JetDashboard Module

## [1.3.10](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.10) - 02.02.2024
* Added: [Crocoblock/suggestions#4996](https://github.com/Crocoblock/suggestions/issues/4996)
* Added: style option for remove button in the Woo Cart Widget
* Fixed: & encoding in redirect url for Login Form
* Fixed: click on submenu for mobile in the Hamburger Panel
* Fixed: minor issues
* Updated: framework loader

## [1.3.9](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.9) - 22.12.2023
* Added: `jet-blocks/reset/email_body ` filter hook
* Added: `Prepend post title with post type` option in the Breadcrumbs widget
* Fixed: `Text Color` option in the Login Form  widget
* Fixed: click on submenu for mobile in the Navigation Menu widget
* Fixed: minor issues
* Updated: Vue js module

## [1.3.8.2](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.8.2) - 03.10.2023
* Fixed: elementor-template Rest API endpoint

## [1.3.8.1](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.8.1) - 28.09.2023
* Fixed: security issue

## [1.3.8](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.8) - 14.09.2023
* Updated: JetDashboard Module

## [1.3.7](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.7) - 03.08.2023
* Fixed: Compatibility global styles for elementor 3.15.0

## [1.3.6](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.6) - 07.06.2023
* Added: [Crocoblock/suggestions#6513](https://github.com/Crocoblock/suggestions/issues/6513)
* Added: [Crocoblock/suggestions#5325](https://github.com/Crocoblock/suggestions/issues/5325)
* Added: additional custom breakpoints compatibility with sticky section
* Fixed: captcha for registration form
* Fixed: minor issues

## [1.3.5](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.5) - 02.12.2022
* Added: Google reCAPTCHA v3 integration
* Update: JetDashboard Module to v2.0.9
* Fixed: Sticky Section compatibility with Elementor Flexbox Container
* Fixed: Hamburger Panel widget compatibility with Elementor Flexbox Container
* Added: `Start Showing Mobile Menu From` option in the Navigation Menu widget
* Fixed: Navigation Menu widget RTL compatibility

## [1.3.4](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.4) - 26.09.2022
* Added: [Crocoblock/suggestions#5837](https://github.com/Crocoblock/suggestions/issues/5837)
* Added: `Enabled for` option in the Navigation Menu Widget for selection breakpoint when Mobile Trigger is activated.
* Fixed: accessibility

## [1.3.3](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.3) - 08.08.2022
* Added: [Crocoblock/suggestions#3921](https://github.com/Crocoblock/suggestions/issues/3921)
* Added: `Use Cache for Template` option in the Hamburger Panel Widget
* Fixed: сompatibility with Elementor 3.7
* Fixed: minor issues

## [1.3.2](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.2) - 14.04.2022
* Added: [Crocoblock/suggestions#4915](https://github.com/Crocoblock/suggestions/issues/4915)
* Added: [Crocoblock/suggestions#3923](https://github.com/Crocoblock/suggestions/issues/3923)
* Fixed: minor issues

## [1.3.1](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.1) - 23.03.2022
* Fixed: elementor 3.6 compatibility

## [1.3.0](https://github.com/ZemezLab/jet-blocks/releases/tag/1.3.0) - 22.12.2021
* Added: [Crocoblock/suggestions#1512](https://github.com/Crocoblock/suggestions/issues/1512)
* Added: [Crocoblock/suggestions#2698](https://github.com/Crocoblock/suggestions/issues/2698)
* Fixed: RTL compatibility
* Fixed: minor issues

## [1.2.10](https://github.com/ZemezLab/jet-blocks/releases/tag/1.2.10) - 23.08.2021
* Fixed: PHP 8 compatibility

## [1.2.9](https://github.com/ZemezLab/jet-blocks/releases/tag/1.2.9) - 30.06.2021
* Added: output validation for html tags settings
* Added: [Crocoblock/suggestions#3049](https://github.com/Crocoblock/suggestions/issues/3049)
* Added: [Crocoblock/suggestions#2916](https://github.com/Crocoblock/suggestions/issues/2916)
* Fixed: compatibility the Search widget with WPML
* Fixed: multiple issues in the Cart widget
* Fixed: prevent php warning

## [1.2.8](https://github.com/ZemezLab/jet-blocks/releases/tag/1.2.8) - 03.03.2021
* Added: layout type for woo card widget
* Added: JS triggers on ajax load template
* Fixed: mini cart display in mega menu item after ajax request
* Fixed: Elementor 3.1.2 compatibility issue

## [1.2.7](https://github.com/ZemezLab/jet-blocks/releases/tag/1.2.7) - 11.12.2020
* Added: support anchor links in the Nav Menu widget
* Update: JetDashboard Module to v2.0.5
* Fixed: compatibility with WP 5.6

## [1.2.6](https://github.com/ZemezLab/jet-blocks/releases/tag/1.2.6) - 13.11.2020
* Update: JetDashboard Module to v2.0.4
* Added: an ability to customize the home link text in the Breadcrumb widget ( [#527](https://github.com/Crocoblock/suggestions/issues/527) )
* Added: an ability to load Hamburger Panel templates via AJAX ( [#1476](https://github.com/Crocoblock/suggestions/issues/1476) )
* Added: [Crocoblock/suggestions#319](https://github.com/Crocoblock/suggestions/issues/319)

## [1.2.5](https://github.com/ZemezLab/jet-blocks/releases/tag/1.2.5) - 12.10.2020
* Update: JetDashboard Module to v2.0.0
* Update: minor improvements in the Breadcrumbs widget
* Added: getting a list of templates in controls through ajax
* Added: start elements animation handlers on opening the Hamburger panel

## [1.2.4](https://github.com/ZemezLab/jet-blocks/releases/tag/1.2.4) - 17.07.2020
* Update: JetDashboard Module to v1.0.16
* Fixed: prevent Rest API error notice

## [1.2.3](https://github.com/ZemezLab/jet-blocks/releases/tag/1.2.3) - 08.06.2020
* Added: multiple performance improvements and bug fixes
* Fixed: compatibility the Auth links widget and Elementor Popup actions

## [1.2.2](https://github.com/ZemezLab/jet-blocks/releases/tag/1.2.2) - 02.04.2020
* Update: JetDashboard Module to v1.0.12
* Update: Breadcrumbs module to 1.0.2
* Added: multiple improvements and bug fixes

## [1.2.1](https://github.com/ZemezLab/jet-blocks/releases/tag/1.2.1) - 28.01.2020
* Update: JetDashboard Module to v1.0.9

## [1.2.0](https://github.com/ZemezLab/jet-blocks/releases/tag/1.2.0) - 02.12.2019
* Added: JetDashboard Module

## [1.1.14](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.14) - 29.11.2019
* Fixed: prevent php error on update DB

## [1.1.13](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.13) - 15.10.2019
* Fixed: js conflict in the Hamburger Panel widget

## [1.1.12](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.12) - 02.10.2019
* Added: compatibility for the upcoming release of JetStylesManager plugin
* Fixed: prevent PHP error in admin

## [1.1.11](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.11) - 19.08.2019
* Added: Editor Load Level Option
* Added: compatibility with new Icons control
* Added: multiple performance improvements and bug fixes
* Fixed: displaying the site logo on https sites

## [1.1.10.1](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.10.1) - 19.07.2019
* Fixed: Breadcrumbs widget

## [1.1.10](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.10) - 18.07.2019
* Fixed: title option in the Breadcrumbs widget

## [1.1.9](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.9) - 11.07.2019
* Added: the ability to use dynamic tags in the Auth Links Widget
* Added: need helps links

## [1.1.8](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.8) - 23.05.2019
* Added: Compatibility `Register Form` with `Advanced noCaptcha & invisible Captcha` plugin
* Update: minify assets

## [1.1.7](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.7) - 24.04.2019
* Added: better RTL compatibility in the Nav Menu Widget
* Update: replace Home URL with site URL in framework loader

## [1.1.6](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.6) - 18.04.2019
* Added: filter hook 'cx_include_module_url' in the `CX_Loader` class

## [1.1.5](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.5) - 26.03.2019
* Added: `Lost password link` option in the Login Form Widget
* Added: additional taxonomy settings for Breadcrumbs Widget
* Added: multiple performance improvements
* Fixed: minor bugs in the Hamburger Panel Widget
* Fixed: prevent php error in the Woo Cart Widget
* Fixed: missing the close button for embedded editor

## [1.1.4](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.4)
* Added: RU localization

## [1.1.3](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.3)
* Fixed: redirection to Custom URL did not work after registration in the Registration Form Widget

## [1.1.2](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.2)
* Added: `Show Cart Dropdown` option in the Woo Shopping Cart Widget
* Fixed: Nav menu CSS

## [1.1.1](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.1)

* Added: multiple mobile menu options in the Nav Menu Widget
* Added: `At the bottom` Dropdown Placement in the Vertical Layout in the Nav Menu Widget
* Added: `Vertical Menu Width` and `Vertical Menu Alignment` controls in the Nav Menu Widget
* Added: `Is Product Search` option in the Search Widget
* Added: multiple performance improvements and bug fixes
* Update: jetblocks icon font

## [1.1.0](https://github.com/ZemezLab/jet-blocks/releases/tag/1.1.0)

* Added: new Breadcrumbs widget
* Added: the full-screen layout for Search widget
* Added: the improved sticky section functionality
* Added: multiple performance improvements and bug fixes
* Added: dummy data

## [1.0.0](https://github.com/ZemezLab/jet-blocks/releases/tag/1.0.0)

* Init
